/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.MountedStorageSyncPacket;
import com.simibubi.create.content.equipment.toolbox.ToolboxMountedStorage;
import com.simibubi.create.content.fluids.tank.storage.FluidTankMountedStorage;
import com.simibubi.create.content.fluids.tank.storage.creative.CreativeFluidTankMountedStorage;
import com.simibubi.create.content.logistics.crate.CreativeCrateMountedStorage;
import com.simibubi.create.content.logistics.depot.storage.DepotMountedStorage;
import com.simibubi.create.content.logistics.vault.ItemVaultMountedStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.pepperbell.simplenetworking.S2CPacket;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3499;
import org.jetbrains.annotations.Nullable;

public class MountedStorageManager {
    private Map<class_2338, MountedItemStorage> itemsBuilder;
    private Map<class_2338, MountedFluidStorage> fluidsBuilder;
    private Map<class_2338, SyncedMountedStorage> syncedItemsBuilder;
    private Map<class_2338, SyncedMountedStorage> syncedFluidsBuilder;
    private ImmutableMap<class_2338, MountedItemStorage> allItemStorages;
    protected MountedItemStorageWrapper items;
    @Nullable
    protected MountedItemStorageWrapper fuelItems;
    protected MountedFluidStorageWrapper fluids;
    private ImmutableMap<class_2338, SyncedMountedStorage> syncedItems;
    private ImmutableMap<class_2338, SyncedMountedStorage> syncedFluids;
    private List<SlottedStorage<ItemVariant>> externalHandlers;
    protected CombinedSlottedStorage<ItemVariant, ? extends SlottedStorage<ItemVariant>> allItems;
    private int syncCooldown;
    private Set<class_2338> interactablePositions;

    public MountedStorageManager() {
        this.reset();
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.allItemStorages = ImmutableMap.copyOf(this.itemsBuilder);
        this.allItems = this.items = new MountedItemStorageWrapper(MountedStorageManager.subMap(this.allItemStorages, this::isExposed));
        this.itemsBuilder = null;
        ImmutableMap<class_2338, MountedItemStorage> fuelMap = MountedStorageManager.subMap(this.allItemStorages, this::canUseForFuel);
        this.fuelItems = fuelMap.isEmpty() ? null : new MountedItemStorageWrapper(fuelMap);
        ImmutableMap fluids = ImmutableMap.copyOf(this.fluidsBuilder);
        this.fluids = new MountedFluidStorageWrapper((ImmutableMap<class_2338, MountedFluidStorage>)fluids);
        this.fluidsBuilder = null;
        this.syncedItems = ImmutableMap.copyOf(this.syncedItemsBuilder);
        this.syncedItemsBuilder = null;
        this.syncedFluids = ImmutableMap.copyOf(this.syncedFluidsBuilder);
        this.syncedFluidsBuilder = null;
    }

    private boolean isExposed(MountedItemStorage storage) {
        return !AllTags.AllMountedItemStorageTypeTags.INTERNAL.matches(storage);
    }

    private boolean canUseForFuel(MountedItemStorage storage) {
        return this.isExposed(storage) && !AllTags.AllMountedItemStorageTypeTags.FUEL_BLACKLIST.matches(storage);
    }

    private boolean isInitialized() {
        return this.itemsBuilder == null;
    }

    private void assertInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("MountedStorageManager is uninitialized");
        }
    }

    protected void reset() {
        this.allItemStorages = null;
        this.items = null;
        this.fuelItems = null;
        this.fluids = null;
        this.externalHandlers = new ArrayList<SlottedStorage<ItemVariant>>();
        this.allItems = null;
        this.itemsBuilder = new HashMap<class_2338, MountedItemStorage>();
        this.fluidsBuilder = new HashMap<class_2338, MountedFluidStorage>();
        this.syncedItemsBuilder = new HashMap<class_2338, SyncedMountedStorage>();
        this.syncedFluidsBuilder = new HashMap<class_2338, SyncedMountedStorage>();
    }

    public void addBlock(class_1937 level, class_2680 state, class_2338 globalPos, class_2338 localPos, @Nullable class_2586 be) {
        Object storage;
        MountedFluidStorageType<?> fluidType;
        Object storage2;
        MountedItemStorageType<?> itemType = MountedItemStorageType.REGISTRY.get(state.method_26204());
        if (itemType != null && (storage2 = itemType.mount(level, state, globalPos, be)) != null) {
            this.addStorage((MountedItemStorage)storage2, localPos);
        }
        if ((fluidType = MountedFluidStorageType.REGISTRY.get(state.method_26204())) != null && (storage = fluidType.mount(level, state, globalPos, be)) != null) {
            this.addStorage((MountedFluidStorage)storage, localPos);
        }
    }

    public void unmount(class_1937 level, class_3499.class_3501 info, class_2338 globalPos, @Nullable class_2586 be) {
        MountedFluidStorageType<?> expectedType;
        MountedFluidStorage fluidStorage;
        MountedItemStorageType<?> expectedType2;
        class_2338 localPos = info.comp_1341();
        class_2680 state = info.comp_1342();
        MountedItemStorage itemStorage = (MountedItemStorage)this.getAllItemStorages().get((Object)localPos);
        if (itemStorage != null && itemStorage.type == (expectedType2 = MountedItemStorageType.REGISTRY.get(state.method_26204()))) {
            itemStorage.unmount(level, state, globalPos, be);
        }
        if ((fluidStorage = (MountedFluidStorage)this.getFluids().storages.get((Object)localPos)) != null && fluidStorage.type == (expectedType = MountedFluidStorageType.REGISTRY.get(state.method_26204()))) {
            fluidStorage.unmount(level, state, globalPos, be);
        }
    }

    public void tick(AbstractContraptionEntity entity) {
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            return;
        }
        HashMap<class_2338, MountedItemStorage> items = new HashMap<class_2338, MountedItemStorage>();
        HashMap<class_2338, MountedFluidStorage> fluids = new HashMap<class_2338, MountedFluidStorage>();
        this.syncedItems.forEach((pos, storage) -> {
            if (storage.isDirty()) {
                items.put((class_2338)pos, (MountedItemStorage)((Object)storage));
                storage.markClean();
            }
        });
        this.syncedFluids.forEach((pos, storage) -> {
            if (storage.isDirty()) {
                fluids.put((class_2338)pos, (MountedFluidStorage)((Object)storage));
                storage.markClean();
            }
        });
        if (!items.isEmpty() || !fluids.isEmpty()) {
            MountedStorageSyncPacket packet = new MountedStorageSyncPacket(entity.method_5628(), items, fluids);
            AllPackets.getChannel().sendToClientsTracking((S2CPacket)packet, (class_1297)entity);
            this.syncCooldown = 8;
        }
    }

    public void handleSync(MountedStorageSyncPacket packet, AbstractContraptionEntity entity) {
        ImmutableMap<class_2338, MountedItemStorage> items = this.getAllItemStorages();
        MountedFluidStorageWrapper fluids = this.getFluids();
        this.reset();
        IdentityHashMap<SyncedMountedStorage, class_2338> syncedStorages = new IdentityHashMap<SyncedMountedStorage, class_2338>();
        try {
            this.itemsBuilder.putAll((Map<class_2338, MountedItemStorage>)items);
            this.fluidsBuilder.putAll((Map<class_2338, MountedFluidStorage>)fluids.storages);
            packet.items.forEach((pos, storage) -> {
                this.itemsBuilder.put((class_2338)pos, (MountedItemStorage)storage);
                syncedStorages.put((SyncedMountedStorage)((Object)storage), (class_2338)pos);
            });
            packet.fluids.forEach((pos, storage) -> {
                this.fluidsBuilder.put((class_2338)pos, (MountedFluidStorage)storage);
                syncedStorages.put((SyncedMountedStorage)((Object)storage), (class_2338)pos);
            });
        }
        catch (Throwable t) {
            Create.LOGGER.error("An error occurred while syncing a MountedStorageManager", t);
        }
        this.initialize();
        Contraption contraption = entity.getContraption();
        syncedStorages.forEach((storage, pos) -> storage.afterSync(contraption, (class_2338)pos));
    }

    public void read(class_2487 nbt, boolean clientPacket, @Nullable Contraption contraption) {
        this.reset();
        try {
            NBTHelper.iterateCompoundList((class_2499)nbt.method_10554("items", 10), tag -> {
                class_2338 pos = class_2512.method_10691((class_2487)tag.method_10562("pos"));
                class_2487 data = tag.method_10562("storage");
                MountedItemStorage.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)data).resultOrPartial(err -> Create.LOGGER.error("Failed to deserialize mounted item storage: {}", err)).map(Pair::getFirst).ifPresent(storage -> this.addStorage((MountedItemStorage)storage, pos));
            });
            NBTHelper.iterateCompoundList((class_2499)nbt.method_10554("fluids", 10), tag -> {
                class_2338 pos = class_2512.method_10691((class_2487)tag.method_10562("pos"));
                class_2487 data = tag.method_10562("storage");
                MountedFluidStorage.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)data).resultOrPartial(err -> Create.LOGGER.error("Failed to deserialize mounted fluid storage: {}", err)).map(Pair::getFirst).ifPresent(storage -> this.addStorage((MountedFluidStorage)storage, pos));
            });
            this.readLegacy(nbt);
            if (nbt.method_10545("interactable_positions")) {
                this.interactablePositions = new HashSet<class_2338>();
                NBTHelper.iterateCompoundList((class_2499)nbt.method_10554("interactable_positions", 10), tag -> {
                    class_2338 pos = class_2512.method_10691((class_2487)tag);
                    this.interactablePositions.add(pos);
                });
            }
        }
        catch (Throwable t) {
            Create.LOGGER.error("Error deserializing mounted storage", t);
        }
        this.initialize();
        if (!clientPacket || contraption == null) {
            return;
        }
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (storage instanceof SyncedMountedStorage) {
                SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
                synced.afterSync(contraption, (class_2338)pos);
            }
        });
        this.getFluids().storages.forEach((pos, storage) -> {
            if (storage instanceof SyncedMountedStorage) {
                SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
                synced.afterSync(contraption, (class_2338)pos);
            }
        });
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        class_2499 items = new class_2499();
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                MountedItemStorage.CODEC.encodeStart((DynamicOps)class_2509.field_11560, storage).resultOrPartial(err -> Create.LOGGER.error("Failed to serialize mounted item storage: {}", err)).ifPresent(encoded -> {
                    class_2487 tag = new class_2487();
                    tag.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)pos));
                    tag.method_10566("storage", encoded);
                    items.add((Object)tag);
                });
            }
        });
        if (!items.isEmpty()) {
            nbt.method_10566("items", (class_2520)items);
        }
        class_2499 fluids = new class_2499();
        this.getFluids().storages.forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                MountedFluidStorage.CODEC.encodeStart((DynamicOps)class_2509.field_11560, storage).resultOrPartial(err -> Create.LOGGER.error("Failed to serialize mounted fluid storage: {}", err)).ifPresent(encoded -> {
                    class_2487 tag = new class_2487();
                    tag.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)pos));
                    tag.method_10566("storage", encoded);
                    fluids.add((Object)tag);
                });
            }
        });
        if (!fluids.isEmpty()) {
            nbt.method_10566("fluids", (class_2520)fluids);
        }
        if (clientPacket) {
            Sets.SetView positions = Sets.union((Set)this.getAllItemStorages().keySet(), (Set)this.getFluids().storages.keySet());
            class_2499 list = new class_2499();
            for (class_2338 pos2 : positions) {
                list.add((Object)class_2512.method_10692((class_2338)pos2));
            }
            nbt.method_10566("interactable_positions", (class_2520)list);
        }
    }

    public void attachExternal(SlottedStorage<ItemVariant> externalStorage) {
        this.externalHandlers.add(externalStorage);
        ArrayList<MountedItemStorageWrapper> all = new ArrayList<MountedItemStorageWrapper>(this.externalHandlers.size() + 1);
        all.add(0, this.items);
        all.addAll(this.externalHandlers);
        this.allItems = new CombinedSlottedStorage(all);
    }

    public CombinedSlottedStorage<ItemVariant, ? extends SlottedStorage<ItemVariant>> getAllItems() {
        this.assertInitialized();
        return this.allItems;
    }

    public ImmutableMap<class_2338, MountedItemStorage> getAllItemStorages() {
        this.assertInitialized();
        return this.allItemStorages;
    }

    public MountedItemStorageWrapper getMountedItems() {
        this.assertInitialized();
        return this.items;
    }

    @Nullable
    public MountedItemStorageWrapper getFuelItems() {
        this.assertInitialized();
        return this.fuelItems;
    }

    public MountedFluidStorageWrapper getFluids() {
        this.assertInitialized();
        return this.fluids;
    }

    public boolean handlePlayerStorageInteraction(Contraption contraption, class_1657 player, class_2338 localPos) {
        if (!(player instanceof class_3222)) {
            return this.interactablePositions != null && this.interactablePositions.contains(localPos);
        }
        class_3222 serverPlayer = (class_3222)player;
        class_3499.class_3501 info = contraption.getBlocks().get(localPos);
        if (info == null) {
            return false;
        }
        MountedStorageManager storageManager = contraption.getStorage();
        MountedItemStorage storage = (MountedItemStorage)storageManager.getAllItemStorages().get((Object)localPos);
        if (storage != null) {
            return storage.handleInteraction(serverPlayer, contraption, info);
        }
        return false;
    }

    private void readLegacy(class_2487 nbt) {
        NBTHelper.iterateCompoundList((class_2499)nbt.method_10554("Storage", 10), tag -> {
            class_2338 pos = class_2512.method_10691((class_2487)tag.method_10562("Pos"));
            class_2487 data = tag.method_10562("Data");
            if (data.method_10545("Toolbox")) {
                this.addStorage(ToolboxMountedStorage.fromLegacy(data), pos);
            } else if (data.method_10545("NoFuel")) {
                this.addStorage(ItemVaultMountedStorage.fromLegacy(data), pos);
            } else if (data.method_10545("Bottomless")) {
                class_1799 supplied = class_1799.method_7915((class_2487)data.method_10562("ProvidedStack"));
                this.addStorage(new CreativeCrateMountedStorage(supplied), pos);
            } else if (data.method_10545("Synced")) {
                this.addStorage(DepotMountedStorage.fromLegacy(data), pos);
            }
        });
        NBTHelper.iterateCompoundList((class_2499)nbt.method_10554("FluidStorage", 10), tag -> {
            class_2338 pos = class_2512.method_10691((class_2487)tag.method_10562("Pos"));
            class_2487 data = tag.method_10562("Data");
            if (data.method_10545("Bottomless")) {
                this.addStorage(CreativeFluidTankMountedStorage.fromLegacy(data), pos);
            } else {
                this.addStorage(FluidTankMountedStorage.fromLegacy(data), pos);
            }
        });
    }

    private void addStorage(MountedItemStorage storage, class_2338 pos) {
        this.itemsBuilder.put(pos, storage);
        if (storage instanceof SyncedMountedStorage) {
            SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
            this.syncedItemsBuilder.put(pos, synced);
        }
    }

    private void addStorage(MountedFluidStorage storage, class_2338 pos) {
        this.fluidsBuilder.put(pos, storage);
        if (storage instanceof SyncedMountedStorage) {
            SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
            this.syncedFluidsBuilder.put(pos, synced);
        }
    }

    private static <K, V> ImmutableMap<K, V> subMap(Map<K, V> map, Predicate<V> predicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((key, value) -> {
            if (predicate.test(value)) {
                builder.put(key, value);
            }
        });
        return builder.build();
    }
}

